using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class SettlementAddressLinkController : Controller
    {
        private readonly PostgresDbContext _context;

        public SettlementAddressLinkController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: SettlementAddressLink
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.SettlementAddressLink.Include(s => s.Region).Include(s => s.Road).Include(s => s.Settlement).Include(s => s.SettlementLocation);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: SettlementAddressLink/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlementAddressLink = await _context.SettlementAddressLink.SingleOrDefaultAsync(m => m.SettlementAddressLinkId == id);
            if (settlementAddressLink == null)
            {
                return NotFound();
            }

            return View(settlementAddressLink);
        }

        // GET: SettlementAddressLink/Create
        public IActionResult Create()
        {
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId");
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name");
            ViewData["SettlementLocationId"] = new SelectList(_context.SettlementLocation, "SettlementLocationId", "Value");
            return View();
        }

        // POST: SettlementAddressLink/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("SettlementAddressLinkId,Begin,Distance,End,RegionId,RoadId,SettlementId,SettlementLocationId")] SettlementAddressLink settlementAddressLink)
        {
            if (ModelState.IsValid)
            {
                _context.Add(settlementAddressLink);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", settlementAddressLink.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", settlementAddressLink.RoadId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", settlementAddressLink.SettlementId);
            ViewData["SettlementLocationId"] = new SelectList(_context.SettlementLocation, "SettlementLocationId", "Value", settlementAddressLink.SettlementLocationId);
            return View(settlementAddressLink);
        }

        // GET: SettlementAddressLink/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlementAddressLink = await _context.SettlementAddressLink.SingleOrDefaultAsync(m => m.SettlementAddressLinkId == id);
            if (settlementAddressLink == null)
            {
                return NotFound();
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", settlementAddressLink.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", settlementAddressLink.RoadId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", settlementAddressLink.SettlementId);
            ViewData["SettlementLocationId"] = new SelectList(_context.SettlementLocation, "SettlementLocationId", "Value", settlementAddressLink.SettlementLocationId);
            return View(settlementAddressLink);
        }

        // POST: SettlementAddressLink/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("SettlementAddressLinkId,Begin,Distance,End,RegionId,RoadId,SettlementId,SettlementLocationId")] SettlementAddressLink settlementAddressLink)
        {
            if (id != settlementAddressLink.SettlementAddressLinkId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(settlementAddressLink);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!SettlementAddressLinkExists(settlementAddressLink.SettlementAddressLinkId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", settlementAddressLink.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", settlementAddressLink.RoadId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", settlementAddressLink.SettlementId);
            ViewData["SettlementLocationId"] = new SelectList(_context.SettlementLocation, "SettlementLocationId", "Value", settlementAddressLink.SettlementLocationId);
            return View(settlementAddressLink);
        }

        // GET: SettlementAddressLink/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlementAddressLink = await _context.SettlementAddressLink.SingleOrDefaultAsync(m => m.SettlementAddressLinkId == id);
            if (settlementAddressLink == null)
            {
                return NotFound();
            }

            return View(settlementAddressLink);
        }

        // POST: SettlementAddressLink/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var settlementAddressLink = await _context.SettlementAddressLink.SingleOrDefaultAsync(m => m.SettlementAddressLinkId == id);
            _context.SettlementAddressLink.Remove(settlementAddressLink);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool SettlementAddressLinkExists(int id)
        {
            return _context.SettlementAddressLink.Any(e => e.SettlementAddressLinkId == id);
        }
    }
}
