using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class ServiceObjectController : Controller
    {
        private readonly PostgresDbContext _context;

        public ServiceObjectController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: ServiceObject
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.ServiceObject.Include(s => s.DepartmentAffiliation).Include(s => s.Region).Include(s => s.Road).Include(s => s.ServiceObjectType).Include(s => s.Settlement);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: ServiceObject/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var serviceObject = await _context.ServiceObject.SingleOrDefaultAsync(m => m.ServiceObjectId == id);
            if (serviceObject == null)
            {
                return NotFound();
            }

            return View(serviceObject);
        }

        // GET: ServiceObject/Create
        public IActionResult Create()
        {
            ViewData["DepartmentAffiliationId"] = new SelectList(_context.DepartmentAffiliation, "DepartmentAffiliationId", "DepartmentAffiliationId");
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId");
            ViewData["ServiceObjectTypeId"] = new SelectList(_context.ServiceObjectType, "ServiceObjectTypeId", "ServiceObjectTypeId");
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name");
            return View();
        }

        // POST: ServiceObject/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("ServiceObjectId,ArrangementElements,Capacity,DepartmentAffiliationId,Distance,LocationAxis,LocationLeft,LocationRight,RegionId,RoadId,ServiceObjectTypeId,SettlementId")] ServiceObject serviceObject)
        {
            if (ModelState.IsValid)
            {
                _context.Add(serviceObject);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["DepartmentAffiliationId"] = new SelectList(_context.DepartmentAffiliation, "DepartmentAffiliationId", "DepartmentAffiliationId", serviceObject.DepartmentAffiliationId);
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", serviceObject.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", serviceObject.RoadId);
            ViewData["ServiceObjectTypeId"] = new SelectList(_context.ServiceObjectType, "ServiceObjectTypeId", "ServiceObjectTypeId", serviceObject.ServiceObjectTypeId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", serviceObject.SettlementId);
            return View(serviceObject);
        }

        // GET: ServiceObject/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var serviceObject = await _context.ServiceObject.SingleOrDefaultAsync(m => m.ServiceObjectId == id);
            if (serviceObject == null)
            {
                return NotFound();
            }
            ViewData["DepartmentAffiliationId"] = new SelectList(_context.DepartmentAffiliation, "DepartmentAffiliationId", "DepartmentAffiliationId", serviceObject.DepartmentAffiliationId);
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", serviceObject.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", serviceObject.RoadId);
            ViewData["ServiceObjectTypeId"] = new SelectList(_context.ServiceObjectType, "ServiceObjectTypeId", "ServiceObjectTypeId", serviceObject.ServiceObjectTypeId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", serviceObject.SettlementId);
            return View(serviceObject);
        }

        // POST: ServiceObject/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("ServiceObjectId,ArrangementElements,Capacity,DepartmentAffiliationId,Distance,LocationAxis,LocationLeft,LocationRight,RegionId,RoadId,ServiceObjectTypeId,SettlementId")] ServiceObject serviceObject)
        {
            if (id != serviceObject.ServiceObjectId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(serviceObject);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!ServiceObjectExists(serviceObject.ServiceObjectId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["DepartmentAffiliationId"] = new SelectList(_context.DepartmentAffiliation, "DepartmentAffiliationId", "DepartmentAffiliationId", serviceObject.DepartmentAffiliationId);
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", serviceObject.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", serviceObject.RoadId);
            ViewData["ServiceObjectTypeId"] = new SelectList(_context.ServiceObjectType, "ServiceObjectTypeId", "ServiceObjectTypeId", serviceObject.ServiceObjectTypeId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", serviceObject.SettlementId);
            return View(serviceObject);
        }

        // GET: ServiceObject/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var serviceObject = await _context.ServiceObject.SingleOrDefaultAsync(m => m.ServiceObjectId == id);
            if (serviceObject == null)
            {
                return NotFound();
            }

            return View(serviceObject);
        }

        // POST: ServiceObject/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var serviceObject = await _context.ServiceObject.SingleOrDefaultAsync(m => m.ServiceObjectId == id);
            _context.ServiceObject.Remove(serviceObject);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool ServiceObjectExists(int id)
        {
            return _context.ServiceObject.Any(e => e.ServiceObjectId == id);
        }
    }
}
