using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class RoadSurfaceController : Controller
    {
        private readonly PostgresDbContext _context;

        public RoadSurfaceController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: RoadSurface
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.RoadSurface.Include(r => r.Region).Include(r => r.Road).Include(r => r.RoadDirection).Include(r => r.StateCommon).Include(r => r.SurfaceTreatment).Include(r => r.SurfaceType);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: RoadSurface/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadSurface = await _context.RoadSurface.SingleOrDefaultAsync(m => m.RoadSurfaceId == id);
            if (roadSurface == null)
            {
                return NotFound();
            }

            return View(roadSurface);
        }

        // GET: RoadSurface/Create
        public IActionResult Create()
        {
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId");
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName");
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "StateCommonId");
            ViewData["SurfaceTreatmentId"] = new SelectList(_context.SurfaceTreatment, "SurfaceTreatmentId", "SurfaceTreatmentId");
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "SurfaceTypeId");
            return View();
        }

        // POST: RoadSurface/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("RoadSurfaceId,Begin,CrossSectionNumber,ElastisityModule,End,LaneCountLeft,LaneCountRight,RegionId,RoadDirectionId,RoadId,RoadSurfaceConstructionId,StateCommonId,SurfaceTreatmentId,SurfaceTypeId")] RoadSurface roadSurface)
        {
            if (ModelState.IsValid)
            {
                _context.Add(roadSurface);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadSurface.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadSurface.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", roadSurface.RoadDirectionId);
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "StateCommonId", roadSurface.StateCommonId);
            ViewData["SurfaceTreatmentId"] = new SelectList(_context.SurfaceTreatment, "SurfaceTreatmentId", "SurfaceTreatmentId", roadSurface.SurfaceTreatmentId);
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "SurfaceTypeId", roadSurface.SurfaceTypeId);
            return View(roadSurface);
        }

        // GET: RoadSurface/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadSurface = await _context.RoadSurface.SingleOrDefaultAsync(m => m.RoadSurfaceId == id);
            if (roadSurface == null)
            {
                return NotFound();
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadSurface.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadSurface.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", roadSurface.RoadDirectionId);
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "StateCommonId", roadSurface.StateCommonId);
            ViewData["SurfaceTreatmentId"] = new SelectList(_context.SurfaceTreatment, "SurfaceTreatmentId", "SurfaceTreatmentId", roadSurface.SurfaceTreatmentId);
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "SurfaceTypeId", roadSurface.SurfaceTypeId);
            return View(roadSurface);
        }

        // POST: RoadSurface/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("RoadSurfaceId,Begin,CrossSectionNumber,ElastisityModule,End,LaneCountLeft,LaneCountRight,RegionId,RoadDirectionId,RoadId,RoadSurfaceConstructionId,StateCommonId,SurfaceTreatmentId,SurfaceTypeId")] RoadSurface roadSurface)
        {
            if (id != roadSurface.RoadSurfaceId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(roadSurface);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!RoadSurfaceExists(roadSurface.RoadSurfaceId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadSurface.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadSurface.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", roadSurface.RoadDirectionId);
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "StateCommonId", roadSurface.StateCommonId);
            ViewData["SurfaceTreatmentId"] = new SelectList(_context.SurfaceTreatment, "SurfaceTreatmentId", "SurfaceTreatmentId", roadSurface.SurfaceTreatmentId);
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "SurfaceTypeId", roadSurface.SurfaceTypeId);
            return View(roadSurface);
        }

        // GET: RoadSurface/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadSurface = await _context.RoadSurface.SingleOrDefaultAsync(m => m.RoadSurfaceId == id);
            if (roadSurface == null)
            {
                return NotFound();
            }

            return View(roadSurface);
        }

        // POST: RoadSurface/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var roadSurface = await _context.RoadSurface.SingleOrDefaultAsync(m => m.RoadSurfaceId == id);
            _context.RoadSurface.Remove(roadSurface);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool RoadSurfaceExists(int id)
        {
            return _context.RoadSurface.Any(e => e.RoadSurfaceId == id);
        }
    }
}
