using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class RoadServiceController : Controller
    {
        private readonly PostgresDbContext _context;

        public RoadServiceController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: RoadService
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.RoadService.Include(r => r.Organization).Include(r => r.Region).Include(r => r.Road).Include(r => r.RoadDirection);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: RoadService/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadService = await _context.RoadService.SingleOrDefaultAsync(m => m.RoadServiceId == id);
            if (roadService == null)
            {
                return NotFound();
            }

            return View(roadService);
        }

        // GET: RoadService/Create
        public IActionResult Create()
        {
            ViewData["OrganizationId"] = new SelectList(_context.Organization, "OrganizationId", "Name");
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId");
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName");
            return View();
        }

        // POST: RoadService/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("RoadServiceId,Begin,End,OrganizationId,RegionId,RoadDirectionId,RoadId,YearBegin")] RoadService roadService)
        {
            if (ModelState.IsValid)
            {
                _context.Add(roadService);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["OrganizationId"] = new SelectList(_context.Organization, "OrganizationId", "Name", roadService.OrganizationId);
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadService.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadService.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", roadService.RoadDirectionId);
            return View(roadService);
        }

        // GET: RoadService/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadService = await _context.RoadService.SingleOrDefaultAsync(m => m.RoadServiceId == id);
            if (roadService == null)
            {
                return NotFound();
            }
            ViewData["OrganizationId"] = new SelectList(_context.Organization, "OrganizationId", "Name", roadService.OrganizationId);
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadService.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadService.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", roadService.RoadDirectionId);
            return View(roadService);
        }

        // POST: RoadService/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("RoadServiceId,Begin,End,OrganizationId,RegionId,RoadDirectionId,RoadId,YearBegin")] RoadService roadService)
        {
            if (id != roadService.RoadServiceId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(roadService);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!RoadServiceExists(roadService.RoadServiceId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["OrganizationId"] = new SelectList(_context.Organization, "OrganizationId", "Name", roadService.OrganizationId);
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadService.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadService.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", roadService.RoadDirectionId);
            return View(roadService);
        }

        // GET: RoadService/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadService = await _context.RoadService.SingleOrDefaultAsync(m => m.RoadServiceId == id);
            if (roadService == null)
            {
                return NotFound();
            }

            return View(roadService);
        }

        // POST: RoadService/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var roadService = await _context.RoadService.SingleOrDefaultAsync(m => m.RoadServiceId == id);
            _context.RoadService.Remove(roadService);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool RoadServiceExists(int id)
        {
            return _context.RoadService.Any(e => e.RoadServiceId == id);
        }
    }
}
