using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class RoadCategoryController : Controller
    {
        private readonly PostgresDbContext _context;

        public RoadCategoryController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: RoadCategory
        public async Task<IActionResult> Index()
        {
            return View(await _context.RoadCategory.ToListAsync());
        }

        // GET: RoadCategory/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadCategory = await _context.RoadCategory.SingleOrDefaultAsync(m => m.RoadCategoryId == id);
            if (roadCategory == null)
            {
                return NotFound();
            }

            return View(roadCategory);
        }

        // GET: RoadCategory/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: RoadCategory/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("RoadCategoryId,Value")] RoadCategory roadCategory)
        {
            if (ModelState.IsValid)
            {
                _context.Add(roadCategory);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(roadCategory);
        }

        // GET: RoadCategory/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadCategory = await _context.RoadCategory.SingleOrDefaultAsync(m => m.RoadCategoryId == id);
            if (roadCategory == null)
            {
                return NotFound();
            }
            return View(roadCategory);
        }

        // POST: RoadCategory/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("RoadCategoryId,Value")] RoadCategory roadCategory)
        {
            if (id != roadCategory.RoadCategoryId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(roadCategory);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!RoadCategoryExists(roadCategory.RoadCategoryId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(roadCategory);
        }

        // GET: RoadCategory/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadCategory = await _context.RoadCategory.SingleOrDefaultAsync(m => m.RoadCategoryId == id);
            if (roadCategory == null)
            {
                return NotFound();
            }

            return View(roadCategory);
        }

        // POST: RoadCategory/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var roadCategory = await _context.RoadCategory.SingleOrDefaultAsync(m => m.RoadCategoryId == id);
            _context.RoadCategory.Remove(roadCategory);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool RoadCategoryExists(int id)
        {
            return _context.RoadCategory.Any(e => e.RoadCategoryId == id);
        }
    }
}
