using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class FlowIntensityController : Controller
    {
        private readonly PostgresDbContext _context;

        public FlowIntensityController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: FlowIntensity
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.FlowIntensity.Include(f => f.Region).Include(f => f.Road).Include(f => f.RoadDirection).Include(f => f.Settlement);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: FlowIntensity/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var flowIntensity = await _context.FlowIntensity.SingleOrDefaultAsync(m => m.FlowIntensityId == id);
            if (flowIntensity == null)
            {
                return NotFound();
            }

            return View(flowIntensity);
        }

        // GET: FlowIntensity/Create
        public IActionResult Create()
        {
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId");
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName");
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name");
            return View();
        }

        // POST: FlowIntensity/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("FlowIntensityId,Begin,DateAdd,End,IntensityBus,IntensityBusCoupled,IntensityCar,IntensityIncrease,IntensityLorryThirty,IntensityLorryTwelve,IntensityLorryTwelveTwenty,IntensityLorryTwentyThirty,IntensityMoto,IntensityMotoSidecar,IntensityTotal,IntensityTractorOverTen,IntensityTractorUnderTen,IntensityTruckEightFourteen,IntensityTruckFourteen,IntensityTruckSixEight,IntensityTruckTwo,IntensityTruckTwoSix,Location,RegionId,RoadDirectionId,RoadId,SettlementId")] FlowIntensity flowIntensity)
        {
            if (ModelState.IsValid)
            {
                _context.Add(flowIntensity);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", flowIntensity.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", flowIntensity.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", flowIntensity.RoadDirectionId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", flowIntensity.SettlementId);
            return View(flowIntensity);
        }

        // GET: FlowIntensity/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var flowIntensity = await _context.FlowIntensity.SingleOrDefaultAsync(m => m.FlowIntensityId == id);
            if (flowIntensity == null)
            {
                return NotFound();
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", flowIntensity.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", flowIntensity.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", flowIntensity.RoadDirectionId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", flowIntensity.SettlementId);
            return View(flowIntensity);
        }

        // POST: FlowIntensity/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("FlowIntensityId,Begin,DateAdd,End,IntensityBus,IntensityBusCoupled,IntensityCar,IntensityIncrease,IntensityLorryThirty,IntensityLorryTwelve,IntensityLorryTwelveTwenty,IntensityLorryTwentyThirty,IntensityMoto,IntensityMotoSidecar,IntensityTotal,IntensityTractorOverTen,IntensityTractorUnderTen,IntensityTruckEightFourteen,IntensityTruckFourteen,IntensityTruckSixEight,IntensityTruckTwo,IntensityTruckTwoSix,Location,RegionId,RoadDirectionId,RoadId,SettlementId")] FlowIntensity flowIntensity)
        {
            if (id != flowIntensity.FlowIntensityId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(flowIntensity);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!FlowIntensityExists(flowIntensity.FlowIntensityId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", flowIntensity.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", flowIntensity.RoadId);
            ViewData["RoadDirectionId"] = new SelectList(_context.RoadDirection, "RoadDirectionId", "DirectionName", flowIntensity.RoadDirectionId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", flowIntensity.SettlementId);
            return View(flowIntensity);
        }

        // GET: FlowIntensity/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var flowIntensity = await _context.FlowIntensity.SingleOrDefaultAsync(m => m.FlowIntensityId == id);
            if (flowIntensity == null)
            {
                return NotFound();
            }

            return View(flowIntensity);
        }

        // POST: FlowIntensity/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var flowIntensity = await _context.FlowIntensity.SingleOrDefaultAsync(m => m.FlowIntensityId == id);
            _context.FlowIntensity.Remove(flowIntensity);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool FlowIntensityExists(int id)
        {
            return _context.FlowIntensity.Any(e => e.FlowIntensityId == id);
        }
    }
}
