using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class BusStopController : Controller
    {
        private readonly PostgresDbContext _context;

        public BusStopController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: BusStop
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.BusStop.Include(b => b.Region).Include(b => b.Road).Include(b => b.Settlement).Include(b => b.StateCommon).Include(b => b.SurfaceType);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: BusStop/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var busStop = await _context.BusStop.SingleOrDefaultAsync(m => m.BusStopId == id);
            if (busStop == null)
            {
                return NotFound();
            }

            return View(busStop);
        }

        // GET: BusStop/Create
        public IActionResult Create()
        {
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "Name");
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name");
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "Value");
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "Name");
            return View();
        }

        // POST: BusStop/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("BusStopId,AreaLandAvailability,AreaStopAvailability,BalanceCost,BusStationCardId,CrossSectionNumber,DateActual,LocationLeft,LocationRight,PocketAvailability,Position,RegionId,RepairCertificate,RoadId,SettlementId,StateCommonId,SurfaceTypeId,ToiletAvailability,YearBuild,YearRepair")] BusStop busStop)
        {
            if (ModelState.IsValid)
            {
                _context.Add(busStop);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", busStop.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", busStop.RoadId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", busStop.SettlementId);
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "StateCommonId", busStop.StateCommonId);
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "SurfaceTypeId", busStop.SurfaceTypeId);
            return View(busStop);
        }

        // GET: BusStop/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var busStop = await _context.BusStop.SingleOrDefaultAsync(m => m.BusStopId == id);
            if (busStop == null)
            {
                return NotFound();
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", busStop.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", busStop.RoadId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", busStop.SettlementId);
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "StateCommonId", busStop.StateCommonId);
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "SurfaceTypeId", busStop.SurfaceTypeId);
            return View(busStop);
        }

        // POST: BusStop/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("BusStopId,AreaLandAvailability,AreaStopAvailability,BalanceCost,BusStationCardId,CrossSectionNumber,DateActual,LocationLeft,LocationRight,PocketAvailability,Position,RegionId,RepairCertificate,RoadId,SettlementId,StateCommonId,SurfaceTypeId,ToiletAvailability,YearBuild,YearRepair")] BusStop busStop)
        {
            if (id != busStop.BusStopId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(busStop);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!BusStopExists(busStop.BusStopId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", busStop.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", busStop.RoadId);
            ViewData["SettlementId"] = new SelectList(_context.Settlement, "SettlementId", "Name", busStop.SettlementId);
            ViewData["StateCommonId"] = new SelectList(_context.StateCommon, "StateCommonId", "StateCommonId", busStop.StateCommonId);
            ViewData["SurfaceTypeId"] = new SelectList(_context.SurfaceType, "SurfaceTypeId", "SurfaceTypeId", busStop.SurfaceTypeId);
            return View(busStop);
        }

        // GET: BusStop/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var busStop = await _context.BusStop.SingleOrDefaultAsync(m => m.BusStopId == id);
            if (busStop == null)
            {
                return NotFound();
            }

            return View(busStop);
        }

        // POST: BusStop/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var busStop = await _context.BusStop.SingleOrDefaultAsync(m => m.BusStopId == id);
            _context.BusStop.Remove(busStop);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool BusStopExists(int id)
        {
            return _context.BusStop.Any(e => e.BusStopId == id);
        }
    }
}
