<?php
    /**
     * @var View               $this
     * @var ActiveDataProvider $dataProvider
     * @var array              $years
     * @var array              $models
     * @var CarSearch          $searchModel
     */
    use common\models\CarSearch;
    use frontend\models\OrderForm;
    use frontend\models\TestdriveForm;
    use frontend\models\QuestionForm;
    use frontend\models\BookingForm;
    use frontend\models\KeytokeyForm;
    use yii\data\ActiveDataProvider;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    use yii\widgets\ListView;
    
    $this->title = 'Nissan Leaf';
    $get_model = \Yii::$app->request->get('CarSearch');
    if(!empty($get_model['model'])) {
        $get_model = $get_model['model'];
    } else {
        $get_model = $searchModel::DEFAULT_MODEL;
    }
    $get_year = \Yii::$app->request->get('CarSearch');
    if(!empty($get_year['year'])) {
        $get_year = $get_year['year'];
    } else {
        $get_year = $searchModel::DEFAULT_YEAR;
    }
    $current_language = \Yii::$app->language;
?>
<!-- Pushy Menu -->
<nav class="pushy pushy-right" id="menu">
    <ul>
        <li class="pushy-link"><a href="#section2"><?= Yii::t('app', 'why_leaf')?></a></li>
        <li class="pushy-link"><a href="#section3"><?= Yii::t('app', 'models')?></a></li>
        <li class="pushy-link"><a href="#section4"><?= Yii::t('app', 'why_we')?></a></li>
        <li class="pushy-link"><a href="#section5"><?= Yii::t('app', 'rent_auto')?></a></li>
        <li class="pushy-link"><a href="#section6"><?= Yii::t('app', 'keytokey')?></a></li>
        <li class="pushy-link"><a href="#section7"><?= Yii::t('app', 'partners')?></a></li>
        <li class="pushy-link"><a href="#section8"><?= Yii::t('app', 'contacts')?></a></li>
    </ul>
</nav>
<!-- Site Overlay -->
<div class="site-overlay"></div>

<section id="select0"></section>
<div class="container for-lang">
    <div class="language">
                    <span>
                        <?php
                            if(\Yii::$app->language == 'ru-RU') {
                                echo 'рус';
                            } else {
                                echo 'укр';
                            }
                        ?>
                    </span>
        <div>
            <?php
                if(\Yii::$app->language == 'ru-RU') {
                    echo Html::a('укр', ['', 'language_id' => 3]);
                } else {
                    echo Html::a('рус', ['', 'language_id' => 2]);
                }
            ?>
        </div>
    </div>
</div>
<header>
    <div class="container" id="menu1">
        <a class="navbar-brand" href="#select0"></a>
    </div>
</header>
<div class="menu-btn">
    <span></span>
    <span></span>
    <span></span>
</div>
<!-- 1 -->
<section class="section1 sections box-1 slider-bg" data-num="0" id="section1">
    <div class="container">
        <div class="slogan_wrapper">
            <div class="text-right">
                <h1><?= Yii::t('app', 'citycar_chose')?></h1>
                <div>
                    <div class="text-right">
                        <a class="btn" data-toggle="modal" data-target="#test_drive">
                            <?= Yii::t('app', 'enroll')?>
                        </a>
                    </div>
                    <div id="menu2">
                        <a class="btn" href="#section3" ><?= Yii::t('app', 'buy_leaf')?></a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row slider_wr_">
            <ul class="slide-ul">
                <li class="active_n">
                    <img src="images/1/bg-1.jpg" alt="">
                    <div class="style">
                        <div class="time-bloks">
                            <div class="time-bloks-line"></div>
                        </div>
                    </div>
                </li>
                <li class="">
                    <img src="images/1/bg-2.jpg" alt="">
                    <div class="style">
                        <div class="time-bloks">
                            <div class="time-bloks-line"></div>
                        </div>
                    </div>
                </li>
                <li class="">
                    <img src="images/1/bg-3.jpg" alt="">
                    <div class="style">
                        <div class="time-bloks">
                            <div class="time-bloks-line"></div>
                        </div>
                    </div>
                </li>
                <li class="">
                    <img src="images/1/bg-4.jpg" alt="">
                    <div class="style">
                        <div class="time-bloks">
                            <div class="time-bloks-line"></div>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    <div class="circle-next">
        <div></div>
    </div>
</section>
<!-- 2 -->
<section class="page_section section2" id="section2">
    <div class="container">
        <div class="row flex-container-md">
            <div class="flex-block-2">
                <div class="text-center">
                    <a class="btn-questions-right"  data-toggle="modal" data-target="#questions"><?= Yii::t('app', 'questions')?></a>
                </div>
            </div>
            <div class="flex-block-2">
                <h2><?= Yii::t('app', 'why_leaf')?></h2>
                <div class="row flex-container-xs">
                    <div class="flex-block-2">
                        <img src="images/2/icon1.png" alt="">
                        <?= Yii::t('app', 'why_leaf_line1')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/2/icon2.png" alt="">
                        <?= Yii::t('app', 'why_leaf_line2')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/2/icon3.png" alt="">
                        <?= Yii::t('app', 'why_leaf_line3')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/2/icon4.png" alt="">
                        <?= Yii::t('app', 'why_leaf_line4')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/2/icon5.png" alt="">
                        <?= Yii::t('app', 'why_leaf_line5')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/2/icon6.png" alt="">
                        <?= Yii::t('app', 'why_leaf_line6')?>
                    </div>
                </div>
                <div class="text-center">
                    <a class="btn" data-toggle="modal" data-target="#test_drive">
                        <?= Yii::t('app', 'enroll')?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- 3  -->
<section class="page_section section3" id="section3">
    <div class="container">
        <h2><?= Yii::t('app', 'models2')?></h2>
        <div class="models_select card">
            <ul class="nav nav-tabs nav-tabs-main" role="tablist">
                <?php
                    $num = 0;
                    foreach($models as $model) {
                        $num++;
                        echo Html::tag('li', Html::a($model, [
                            '/',
                        ], [
                            'data' => [
                                'year' => $get_year,
                                'model' => $model,
                                'toggle' => 'tab',
                            ],
                            'role' => 'tab',
                            'aria-controls' => 'tabpanel'.$num,
                            'class' => 'model-picker',
                        ]), [
                            'role' => 'presentation',
                            'class' => ( $get_model == $model ) ? 'active' : '',
                        ]);
                    }
                ?>
            </ul>
            
            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="years_select tab-pane active" id="tabpanel1">
                    <ul class="nav nav-tabs nav-tabs-year" role="tablist">
                        <li role="presentation" class="active"><span><?= Yii::t('app', 'year_made')?></span></li>
                        <?php
                            $num1 = 0;
                            foreach($years as $year) {
                                $num1++;
                                echo Html::tag('li', Html::a($year, [
                                    '/',
                                ], [
                                    'data' => [
                                        'year' => $year,
                                        'model' => $get_model,
                                        'toggle' => 'tab',
                                    ],
                                    'aria-controls' => 'tabpanel1'.$num1,
                                    'role' => 'tab',
                                    'class' => 'year-picker',
                                ]), [
                                    'role' => 'presentation',
                                    'class' => ( $get_year == $year ) ? 'active' : '',
                                ]);
                            }
                        ?>
                    </ul>
                    
                    <!-- Tab panes -->
                    <div class="tab-content cartabscont">
                        <div class="loadcars">
                        <div role="tabpanel" class="tab-pane active" id="tabpanel11">
                            <?php
                                echo ListView::widget([
                                    'dataProvider' => $dataProvider,
                                    'layout'       => '{items}',
                                    'options'      => [
                                        'tag' => 'div',
                                        'class' => 'owl-carousel',
                                    ],
                                    'itemOptions'  => [
                                        'tag' => 'div',
                                        'class' => 'item',
                                    ],
                                    'itemView'     => '_car_view',
                                ]);
                            ?>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- 4 -->
<section class="page_section section4" id="section4">
    <div class="container">
        <div class="row flex-container-md">
            <div class="flex-block-2">
                <h2><?= Yii::t('app', 'why_we')?></h2>
                <div class="row flex-container-xs">
                    <div class="flex-block-2">
                        <img src="images/4/icon1.png" alt="">
                        <?= Yii::t('app', 'why_we_line1')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/4/icon2.png" alt="">
                        <?= Yii::t('app', 'why_we_line2')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/4/icon3.png" alt="">
                        <?= Yii::t('app', 'why_we_line3')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/4/icon4.png" alt="">
                        <?= Yii::t('app', 'why_we_line4')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/4/icon5.png" alt="">
                        <?= Yii::t('app', 'why_we_line5')?>
                    </div>
                    <div class="flex-block-2">
                        <img src="images/4/icon6.png" alt="">
                        <?= Yii::t('app', 'why_we_line6')?>
                    </div>
                </div>
                <div class="text-center">
                    <a class="btn" data-toggle="modal" data-target="#test_drive">
                        <?= Yii::t('app', 'enroll')?>
                    </a>
                </div>
            </div>
            <div class="flex-block-2">
                <div class="text-center">
                    <a class="btn-questions-left" data-toggle="modal" data-target="#questions">
                        <?= Yii::t('app', 'questions')?></a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- 5  -->
<section class="page_section section5" id="section5">
    <div class="container">
        <h2><?= Yii::t('app', 'rent_auto')?></h2>
        <div class="row flex-container-md">
            <div class="flex-block-2">
                <div class="r-b-p-2 m-b-20">
                    <div>
                        <p><strong><?= Yii::t('app', 'rent_auto1')?></strong></p>
                    </div>
                    <div>
                        <img src="images/5/img-4.png" alt="">
                    </div>
                </div>
                <p class="r-b-p-2"><span style="font-size:15px;"><?= Yii::t('app', 'rent_auto2')?></span></p>
            </div>
            <div class="flex-block-2">
                <div class="card">
                    <h3><?= Yii::t('app', 'rent_auto3')?></h3>
                    <div class="price">
                        <div class="price-row">
                            <div class="price-name-wr">
                                <div class="price-name">
                                    <div class="price-name-title">День</div>
                                    <div class="price-name-border">
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="price-cost">50$</div>
                        </div>
                        <div class="price-row">
                            <div class="price-name-wr">
                                <div class="price-name">
                                    <div class="price-name-title">5 <?= Yii::t('app', 'days')?></div>
                                    <div class="price-name-border">
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="price-cost">200$</div>
                        </div>
                        <div class="price-row">
                            <div class="price-name-wr">
                                <div class="price-name">
                                    <div class="price-name-title"><?= Yii::t('app', 'weeks')?></div>
                                    <div class="price-name-border">
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="price-cost">250$</div>
                        </div>
                        <div class="price-row">
                            <div class="price-name-wr">
                                <div class="price-name">
                                    <div class="price-name-title"><?= Yii::t('app', 'month')?></div>
                                    <div class="price-name-border">
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="price-cost">900$</div>
                        </div>
                        <div class="text-right">
                            <div class="deposit">
                                <p>+ 500$</p><p><span><?= Yii::t('app', 'deposit')?></span></p>
                            </div>
                        </div>
                    </div>
                    <h3><?= Yii::t('app', 'dontforget1')?></h3>
                    <ul>
                        <li><?= Yii::t('app', 'dontforget2')?></li>
                        <li><?= Yii::t('app', 'dontforget3')?></li>
                        <li><?= Yii::t('app', 'dontforget4')?></li>
                    </ul>
                    <h3><?= Yii::t('app', 'rent1')?></h3>
                    <div class="row flex-container-xs">
                        <div class="flex-block-3">
                            <img src="images/5/img-1.jpg" alt=""><br>
                            <?= Yii::t('app', 'rent2')?>
                        </div>
                        <div class="flex-block-3">
                            <img src="images/5/img-2.jpg" alt=""><br>
                            <?= Yii::t('app', 'rent3')?>
                        </div>
                        <div class="flex-block-3">
                            <img src="images/5/img-3.jpg" alt=""><br>
                            <?= Yii::t('app', 'rent4')?>
                        </div>
                    
                    </div>
                </div>
                <div class="text-center">
                    <a class="btn" data-toggle="modal" data-target="#application">
                        <?= Yii::t('app', 'rent_button')?>
                    </a>
                </div>
            
            </div>
        </div>
    </div>
</section>
<!-- 6 -->
<section class="page_section section6" id="section6">
    <div class="container">
        <div class="row flex-container-md">
            <div class="flex-block-2"></div>
            <div class="flex-block-2">
                <h2><?= Yii::t('app', 'keytokey')?></h2>
                <h3><?= Yii::t('app', 'keytokey11')?></h3>
                <p><strong><?= Yii::t('app', 'keytokey12')?></strong></p>
                <p><em>"<?= Yii::t('app', 'keytokey2')?></em></p>
                <p><em><?= Yii::t('app', 'keytokey3')?>"</em></p>
                <div class="blue">
                    <p><?= Yii::t('app', 'keytokey4')?></p>
                    <div class="m-b-10">
                        <div class="d-inline-block m-b-10">
                            <a class="btn" data-toggle="modal" data-target="#zayavka">
                                <?= Yii::t('app', 'submit_but1')?>
                            </a>
                        </div>
                        <a href="https://www.facebook.com/electrocars.com.ua/" class="facebook m-b-10"><span> <?= Yii::t('app', 'be_friend')?></span></a>
                    </div>
                    <p><em><?= Yii::t('app', 'share_fb')?></em></p>
                </div>
                <p class="text-center"><strong><?= Yii::t('app', 'chose_var')?></strong></p>
                <ul>
                    <li><?= Yii::t('app', 'leaf_days5')?></li>
                    <li><?= Yii::t('app', 'leaf_days3')?></li>
                </ul>
            </div>
        </div>
    </div>
</section>
<!-- 7 -->
<section class="page_section section7" id="section7">
    <div class="container">
        <h2><?= Yii::t('app', 'partners')?></h2>
        <div class="row flex-container">
            <div class="flex-block">
                <img src="images/7/logo-1.png" alt="">
            </div>
            <div class="flex-block">
                <img src="images/7/logo-2.png" alt="">
            </div>
            <div class="flex-block">
                <img src="images/7/logo-3.png" alt="">
            </div>
            <div class="flex-block">
                <img src="images/7/logo-4.png" alt="">
            </div>
        </div>
    </div>
</section>
<!-- 8  -->
<div class="section8" id="section8">
    <div class="container">
        <div class="contacts">
            <div class="contacts-tile"><h2><?= Yii::t('app', 'contacts')?></h2></div>
            <div class="contacts-block">
                <p>+38 (044) <strong>578-18-17</strong><br>
                    +38 (073) <strong>153-30-05</strong><br>
                    +38 (050) <strong>517-70-70</strong></p>
                <p><?= Yii::t('app', 'kyiv')?><br><?= Yii::t('app', 'contacts1')?></p>
                <p>
                    <a class="link" href="mailto:support@electrocars.com.ua">support@electrocars.com.ua</a>
                    <br>
                    <a class="link" href="electrocars.com.ua">electrocars.com.ua</a>
                </p>
            </div>
            <img class="contacts-img" src="images/8/bg-contacts.png" alt="">
        </div>
    </div>
    <div class="gmap" id="map"></div>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA_0T2bU2ZE-8ltMdy0h-HT-kgwF67bD5c&callback=initMap"></script>
    <script type="text/javascript">
        var map;
        var posLat =  50.4890503;
        var poslng =  30.4737441;
        function initMap() {
            map = new google.maps.Map(document.getElementById('map'), {
                center: {lat: posLat, lng: poslng},
                zoom: 17,
                scrollwheel: false
                //                    draggable:false
                
            });
            var image1 = new google.maps.MarkerImage('images/marker.png',
                new google.maps.Size(38, 43),
                new google.maps.Point(0,0),
                new google.maps.Point(38, 43)
            );
            var markers = [];
            var marker = new google.maps.Marker({
                position: new google.maps.LatLng(posLat, poslng),
                map: map,
                title: 'ElectroCars',
                icon: image1
            });
            markers.push(marker);
        }
    </script>
</div>

<!-- 9 -->
<footer>
    <div class="container">
        <div class="row flex-container-sm">
            <div class="flex-block-2">
                <p>© 2016 <?= Yii::t('app', 'footer1')?><br>
                    <?= Yii::t('app', 'footer2')?></p>
            </div>
            <div class="flex-block-2">
                <a href="http://artweb.ua/"><?= Yii::t('app', 'footer3')?><img src="images/9/artweb.png" alt="Артвеб"></a>      </div>
        </div>
    </div>
</footer>

<!-- Modal success -->
<div class="modal fade" id="success_modal" tabindex="-1" role="dialog" aria-labelledby="test_drive" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
        <h4>Ваша заявка принята.</h4>
      </div>
      <div class="modal-body" style="text-align: center">
        Мы свяжемся с вами в ближайшее время.
      </div>
    </div>
  </div>
</div>

<!-- Modal Записаться на тест-драйв -->
<div class="modal fade" id="test_drive" tabindex="-1" role="dialog" aria-labelledby="test_drive" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
        <h4><?= Yii::t('app', 'enroll')?></h4>
      </div>
      <div class="modal-body">
          <?php $model = new TestdriveForm();
              $form = ActiveForm::begin([
                                            'id'     => 'form_testdrive',
                                            'action' => 'site/testdrive',
                                        ]); ?>
        <div class="form-group">
            <?= $form->field($model, 'username')->textInput([ 'autofocus' => true,'class' => 'form-control custom-input-2' ]) ?>
        </div>
        <div class="form-group danger-text">
            <?= $form->field($model, 'phone')->textInput(['class' => 'form-control custom-input-2' ])?>
        </div>
        <div class="form-footer button-wrapper">
            <?= Html::submitButton(Yii::t('app', 'send'), [ 'class' => 'btn' ], [ 'name' => 'signup-button' ]) ?>
        </div>
          
          <?php ActiveForm::end(); ?>
      </div>
    </div>
  </div>
</div>

<!-- Модальное окно Остались вопросы? -->
<div class="modal fade" id="questions" tabindex="-1" role="dialog" aria-labelledby="questions" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
        <h4><?= Yii::t('app', 'questions')?></h4>
      </div>
      <div class="modal-body">
          <?php $model = new QuestionForm();
              $form = ActiveForm::begin([
                                            'id'     => 'form_question',
                                            'action' => 'site/question',
                                        ]); ?>

        <div class="form-group"><?= $form->field($model, 'username')
                                         ->textInput([ 'autofocus' => true,'class' => 'form-control custom-input-2' ]) ?></div>
        <div class="form-group danger-text"><?= $form->field($model, 'phone')
                                                     ->textInput(['class' => 'form-control custom-input-2' ]) ?></div>
        <div class="form-group danger-text"><?= $form->field($model, 'email')
                                                     ->textInput(['class' => 'form-control custom-input-2' ]) ?></div>
        <div class="form-group"><?= $form->field($model, 'message')
                                         ->textarea(['class' => 'form-control custom-input-2' ]) ?></div>

        <div class="form-footer button-wrapper">
            <?= Html::submitButton(Yii::t('app', 'send'), [ 'class' => 'btn' ], [ 'name' => 'signup-button' ]) ?>
        </div>
          
          <?php ActiveForm::end(); ?>
      </div>
    </div>
  </div>
</div>

<!-- Модальное окно Оставить заявку? -->
<div class="modal fade" id="zayavka" tabindex="-1" role="dialog" aria-labelledby="zayavka" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
        <h4><?= Yii::t('app', 'keytokey')?></h4>
      </div>
      <div class="modal-body">
          <?php $model = new KeytokeyForm();
              $form = ActiveForm::begin([
                                            'id'     => 'form_keytokey',
                                            'action' => 'site/keytokey',
                                        ]); ?>
        <div class="form-group">
            <?= $form->field($model, 'username')->textInput([ 'autofocus' => true,'class' => 'form-control custom-input-2' ]) ?>
        </div>
        <div class="form-group danger-text">
            <?= $form->field($model, 'phone')->textInput(['class' => 'form-control custom-input-2' ]) ?>
        </div>
        <div class="form-group danger-text">
            <?= $form->field($model, 'email')->textInput(['class' => 'form-control custom-input-2' ]) ?>
        </div>
        <div class="form-group"><?= $form->field($model, 'date_count')->dropDownList([
                                                                                         '3' => '3 '.Yii::t('app', 'days'),
                                                                                         '5' => '5 '.Yii::t('app', 'days')], ['class' => 'custom-input-2 form-control']) ?>
        </div>

        <div class="form-footer button-wrapper">
            <?= Html::submitButton(Yii::t('app', 'send'), [ 'class' => 'btn' ], [ 'name' => 'signup-button' ]) ?>
        </div>
          
          <?php ActiveForm::end(); ?>
      </div>
    </div>
  </div>
</div>

<!-- Модальное окно Оставить заявку? -->
<div class="modal fade" id="application" tabindex="-1" role="dialog" aria-labelledby="application" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
        <h4>Заявка на прокат авто</h4>
      </div>
      <div class="modal-body">
          <?php $model = new BookingForm();
              $form = ActiveForm::begin([
                                            'id'     => 'form_booking',
                                            'action' => 'site/booking',
                                        ]); ?>

        <div class="form-group"><?= $form->field($model, 'username')->textInput([ 'autofocus' => true,'class' => 'form-control custom-input-2' ]) ?></div>
        <div class="form-group danger-text"><?= $form->field($model, 'phone')->textInput(['class' => 'form-control custom-input-2' ]) ?></div>
        <div class="form-group danger-text"><?= $form->field($model, 'email')->textInput(['class' => 'form-control custom-input-2' ]) ?></div>

        <div class="input-blocks datepicker_ required">
          <div class="datepicker_title"><?= Yii::t('app', 'bron')?>:</div>
          <div class="form-group-2-l danger-text">
              <?= $form->field($model, 'date_from')
                       ->textInput(['class' => 'form-control']) ?>
              <?= $form->field($model, 'date_to')
                       ->textInput(['class' => 'form-control']) ?>
          </div>
        </div>
        <div class="form-footer button-wrapper">
            <?= Html::submitButton(Yii::t('app', 'comment'), [ 'class' => 'btn' ], [ 'name' => 'signup-button' ]) ?>
        </div>
          
          <?php ActiveForm::end(); ?>
      </div>
    </div>
  </div>
</div>

<!-- Модальное окно buy? -->
<div class="modal fade" id="buy" tabindex="-1" role="dialog" aria-labelledby="buy" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
        <h4 class="model-car-name"></h4>
      </div>
      <div class="modal-body">
          <?php $model = new OrderForm();
              $form = ActiveForm::begin([
                                            'id'     => 'form_buy',
                                            'action' => 'site/buy',
                                        ]); ?>

        <div class="input-blocks"><?= $form->field($model, 'username')
                                           ->textInput([ 'autofocus' => true,'class' => 'form-control custom-input-2' ]) ?></div>
        <div class="input-blocks danger-text"><?= $form->field($model, 'phone')
                                                       ->textInput(['class' => 'form-control custom-input-2' ]) ?></div>
        <div class="input-blocks danger-text"><?= $form->field($model, 'email')
                                                       ->textInput(['class' => 'form-control custom-input-2' ]) ?></div>
          
          <?= $form->field($model, 'model')
                   ->hiddenInput()
                   ->label(false) ?>

        <div class="form-footer">
            <?= Html::submitButton(Yii::t('app', 'send'), [ 'class' => 'btn' ], [ 'name' => 'signup-button' ]) ?>
        </div>
          
          <?php ActiveForm::end(); ?>
      </div>
    </div>
  </div>
</div>