<?php
namespace frontend\models;

use common\models\Customers;
use yii\base\Model;
use Yii;

/**
 * Signup form
 */
class QuestionForm extends Model
{
    public $username;
    public $email;
    public $phone;
    public $message;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['username','surname'], 'string', 'min' => 2, 'max' => 255],

            ['email', 'email'],
            [['email','phone'], 'string', 'max' => 255],

            ['phone', 'required'],
            [['phone','model'], 'safe'],

            [['message'],'string']

        ];
    }

    public function attributeLabels()
    {
        return [
            'username'=>Yii::t('app', 'username'),
            'phone'=>'Телефон',
            'email'=>'E-мейл',
            'message'=>Yii::t('app', 'text_message')
        ];
    }

}
