<?php
namespace frontend\models;

use common\models\Customers;
use yii\base\Model;
use Yii;

/**
 * Signup form
 */
class OrderForm extends Model
{
    public $username;
    public $email;
    public $phone;
    public $model;
    public $model_name;
    public $model_year;
    public $model_color;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['username','surname'], 'string', 'min' => 2, 'max' => 255],

            ['email', 'email'],
            [['email','phone'], 'string', 'max' => 255],

            ['phone', 'required'],
            [['phone','model_name','model_year','model_color'], 'safe']

        ];
    }

    public function attributeLabels()
    {
        return [
            'username'=>Yii::t('app', 'username'),
            'phone'=>'Телефон',
            'email'=>'Е-мейл',
            'model_name'=>'',
            'model_year' => '',
            'model_color' => '',
        ];
    }

}
