<?php
namespace frontend\models;

use common\models\Customers;
use yii\base\Model;
use Yii;

/**
 * Signup form
 */
class KeytokeyForm extends Model
{
    public $username;
    public $email;
    public $phone;
    public $date_count;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['username','surname'], 'string', 'min' => 2, 'max' => 255],

            ['email', 'email'],
            [['email','phone'], 'string', 'max' => 255],

            ['phone', 'required'],
            [['phone','model'], 'safe'],

            [['date_count'],'string']

        ];
    }

    public function attributeLabels()
    {
        return [
            'username'=>Yii::t('app', 'username'),
            'phone'=>'Телефон',
            'email'=>'E-мейл',
            'date_count'=>Yii::t('app', 'numdays'),
        ];
    }

}
