<?php
namespace frontend\models;

use common\models\Customers;
use yii\base\Model;
use Yii;

/**
 * Signup form
 */
class BookingForm extends Model
{
    public $username;
    public $phone;
    public $email;
    public $date_from;
    public $date_to;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['username','surname'], 'string', 'min' => 2, 'max' => 255],

            ['phone', 'required'],
            [['phone','model'], 'safe'],

            ['email', 'email'],
            [['email','phone'], 'string', 'max' => 255],

            [['date_from'],'string'],
            [['date_to'],'string'],

        ];
    }

    public function attributeLabels()
    {
        return [
            'username'=>Yii::t('app', 'username'),
            'phone'=>'Телефон',
            'email'=>'E-mail',
            'date_from'=>Yii::t('app', 'from'),
            'date_to'=>Yii::t('app', 'to'),
        ];
    }

}
