<?php
    namespace frontend\controllers;
    
    use common\models\Buys;
    use common\models\Car;
    use common\models\CarSearch;
    use common\models\Emails;
    use common\models\Quest;
    use Yii;
    use yii\base\InvalidParamException;
    use yii\data\ActiveDataProvider;
    use yii\web\BadRequestHttpException;
    use yii\web\Controller;
    use yii\filters\VerbFilter;
    use yii\filters\AccessControl;
    use common\models\LoginForm;
    use frontend\models\PasswordResetRequestForm;
    use frontend\models\ResetPasswordForm;
    use frontend\models\SignupForm;
    use frontend\models\ContactForm;
    use common\widgets\Mailer;
    use yii\web\Response;
    use yii\web\ResponseFormatterInterface;

    /**
     * Site controller
     */
    class SiteController extends Controller
    {
        
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'access' => [
                    'class' => AccessControl::className(),
                    'only'  => [
                        'logout',
                        'signup',
                    ],
                    'rules' => [
                        [
                            'actions' => [ 'signup' ],
                            'allow'   => true,
                            'roles'   => [ '?' ],
                        ],
                        [
                            'actions' => [ 'logout' ],
                            'allow'   => true,
                            'roles'   => [ '@' ],
                        ],
                    ],
                ],
                'verbs'  => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'logout' => [ 'post' ],
                    ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function actions()
        {
            return [
                'error'   => [
                    'class' => 'yii\web\ErrorAction',
                ],
                'captcha' => [
                    'class'           => 'yii\captcha\CaptchaAction',
                    'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : NULL,
                ],
            ];
        }
        
        /**
         * Displays homepage.
         * @return mixed
         */
        public function actionIndex()
        {
            $years = Car::find()
                        ->distinct()
                        ->select('year')
                ->orderBy('year')
                        ->asArray()
                        ->column();
            $models = Car::find()
                         ->distinct()
                         ->select('model')->orderBy('year')
                         ->asArray()
                         ->column();
            if(\Yii::$app->request->isPost) {
                $lang = \Yii::$app->request->post('lang');
                if(!empty($lang)) {
                    \Yii::$app->language = $lang;
                }
            }
            $searchModel = new CarSearch(['scenario' => CarSearch::SCENARIO_PUBLIC]);
            $dataProvider = $searchModel->search(\Yii::$app->request->queryParams);
            return $this->render('index', [
                'dataProvider' => $dataProvider,
                'searchModel' => $searchModel,
                'years'        => $years,
                'models'       => $models,
            ]);
        }
        
        /**
         * Logs in a user.
         * @return mixed
         */
        public function actionLogin()
        {
            $this->layout = false;
            if(!Yii::$app->user->isGuest) {
                return $this->goHome();
            }
            
            $model = new LoginForm();
            if($model->load(Yii::$app->request->post()) && $model->login()) {
                return $this->goBack();
            } else {
                return $this->render('login', [
                    'model' => $model,
                ]);
            }
        }
        
        /**
         * Logs out the current user.
         * @return mixed
         */
        public function actionLogout()
        {
            Yii::$app->user->logout();
            
            return $this->goHome();
        }
        
        /**
         * Displays contact page.
         * @return mixed
         */
        public function actionContact()
        {
            $model = new ContactForm();
            if($model->load(Yii::$app->request->post()) && $model->validate()) {
                if($model->sendEmail(Yii::$app->params[ 'adminEmail' ])) {
                    Yii::$app->session->setFlash('success', 'Thank you for contacting us. We will respond to you as soon as possible.');
                } else {
                    Yii::$app->session->setFlash('error', 'There was an error sending email.');
                }
                
                return $this->refresh();
            } else {
                return $this->render('contact', [
                    'model' => $model,
                ]);
            }
        }
        
        /**
         * Displays about page.
         * @return mixed
         */
        public function actionAbout()
        {
            return $this->render('about');
        }
        
        /**
         * Signs user up.
         * @return mixed
         */
        public function actionSignup()
        {
            $this->layout = false;
            $model = new SignupForm();
            if($model->load(Yii::$app->request->post())) {
                if($user = $model->signup()) {
                    if(Yii::$app->getUser()
                                ->login($user)
                    ) {
                        return $this->goHome();
                    }
                }
            }
            
            return $this->render('signup', [
                'model' => $model,
            ]);
        }
        
        /**
         * Requests password reset.
         * @return mixed
         */
        public function actionRequestPasswordReset()
        {
            $model = new PasswordResetRequestForm();
            if($model->load(Yii::$app->request->post()) && $model->validate()) {
                if($model->sendEmail()) {
                    Yii::$app->session->setFlash('success', 'Check your email for further instructions.');
                    
                    return $this->goHome();
                } else {
                    Yii::$app->session->setFlash('error', 'Sorry, we are unable to reset password for email provided.');
                }
            }
            
            return $this->render('requestPasswordResetToken', [
                'model' => $model,
            ]);
        }
        
        /**
         * Resets password.
         *
         * @param string $token
         *
         * @return mixed
         * @throws BadRequestHttpException
         */
        public function actionResetPassword($token)
        {
            try {
                $model = new ResetPasswordForm($token);
            } catch(InvalidParamException $e) {
                throw new BadRequestHttpException($e->getMessage());
            }
            
            if($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
                Yii::$app->session->setFlash('success', 'New password was saved.');
                
                return $this->goHome();
            }
            
            return $this->render('resetPassword', [
                'model' => $model,
            ]);
        }
        
        public function actionTestdrive()
        {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            $message = Mailer::widget([ 'type'    => 'test',
                             'subject' => 'Запись на тест-драйв',
                             'params'  => Yii::$app->request->post('TestdriveForm'),
            ]);
            $model = new Emails();
            
            $model->load(Yii::$app->request->post(), 'TestdriveForm');
            if ($model->save()) {
                return [
                    'success' => true,
                    'message' => $message,
                ];
            }
        }
        
        /**
         * @throws \Exception
         */
        public function actionBuy()
        {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            Mailer::widget([ 'type'    => 'buy',
                             'subject' => 'Покупка автомобиля',
                             'params'  => Yii::$app->request->post('OrderForm'),
            ]);
            $model = new Buys();
            $car = Car::findOne(Yii::$app->request->post('OrderForm')['model']);
            
            $model->model_name = $car->model;
            $model->model_year = $car->year;
            $model->model_color = $car->color;
            
            $model->load(Yii::$app->request->post(), 'OrderForm');
            if ($model->save()) {
                return [
                    'success' => true,
                ];
            }
        }
        public function actionQuestion()
        {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            Mailer::widget([ 'type'    => 'question',
                             'subject' => 'Вопросы',
                             'params'  => Yii::$app->request->post('QuestionForm'),
            ]);
            $model = new Emails([
                'scenario' => Emails::SCENARIO_QUESTION,
            ]);

            $model->load(Yii::$app->request->post(), 'QuestionForm');
            if ($model->save()) {
                return [
                    'success' => true,
                ];
            }
        }
        public function actionBooking()
        {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            Mailer::widget([ 'type'    => 'booking',
                             'subject' => 'Бронирование авто',
                             'params'  => Yii::$app->request->post('BookingForm'),
            ]);
            $model = new Emails([
                'scenario' => Emails::SCENARIO_BOOKING,
            ]);

            $model->load(Yii::$app->request->post(), 'BookingForm');
            if ($model->save()) {
                return [
                    'success' => true,
                ];
            }
        }
        public function actionKeytokey()
        {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            Mailer::widget([ 'type'    => 'keytokey',
                             'subject' => 'Акция Ключ-на-ключ',
                             'params'  => Yii::$app->request->post('KeytokeyForm'),
            ]);
            $model = new Emails([
                'scenario' => Emails::SCENARIO_KEY,
            ]);

            $model->load(Yii::$app->request->post(), 'KeytokeyForm');
            if ($model->save()) {
                return [
                    'success' => true,
                ];
            }
        }
    }
