<?php
    use common\models\Language;
    use yii\bootstrap\Html;
    
    /**
     * @var Language   $current   Current language
     * @var Language[] $languages Available languages
     */
?>
<div id="language_picker">
    <span id="current_language">
        <?php
            echo $current->name;
        ?>
        <span class="show-more-language">▼</span>
    </span>
    <ul id="languages">
        <?php
            foreach($languages as $language) {
                ?>
                <li class="item-language">
                    <?php
                        echo Html::a($language->name, '/' . $language->url . Yii::$app->getRequest()
                                                                                      ->getLanguageUrl());
                    ?>
                </li>
                <?php
            }
        ?>
    </ul>
</div>
