<?php
    
    namespace common\modules\language\models;
    
    use Yii;
    use yii\db\ActiveRecord;
    
    /**
     * This is the model class for table "language".
     * @property integer $language_id
     * @property string  $url
     * @property string  $local
     * @property string  $name
     * @property boolean $default
     * @property integer $date_create
     * @property integer $date_update
     */
    class Language extends \yii\db\ActiveRecord
    {
        
        public static $current = null;
        
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'language';
        }
    
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'timestamp' => [
                    'class' => 'yii\behaviors\TimestampBehavior',
                    'attributes' => [
                        ActiveRecord::EVENT_BEFORE_INSERT => [
                            'date_create',
                            'date_update',
                        ],
                        ActiveRecord::EVENT_BEFORE_UPDATE => [
                            'date_update',
                        ],
                    ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'url',
                        'local',
                        'name',
                        'date_create',
                        'date_update',
                    ],
                    'required',
                ],
                [
                    [ 'default' ],
                    'boolean',
                ],
                [
                    [
                        'date_create',
                        'date_update',
                    ],
                    'integer',
                ],
                [
                    [
                        'url',
                        'local',
                        'name',
                    ],
                    'string',
                    'max' => 255,
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'language_id' => Yii::t('app', 'Language ID'),
                'url'         => Yii::t('app', 'Url'),
                'local'       => Yii::t('app', 'Local'),
                'name'        => Yii::t('app', 'Name'),
                'default'     => Yii::t('app', 'Default'),
                'date_create' => Yii::t('app', 'Date Create'),
                'date_update' => Yii::t('app', 'Date Update'),
            ];
        }
    
        /**
         * Get current language
         *
         * @return null|Language
         */
        public static function getCurrent()
        {
            if(self::$current === null) {
                self::$current = self::getDefaultLanguage();
            }
            return self::$current;
        }
    
        /**
         * Set current language by Url param
         *
         * @param null|string $url Language url param
         */
        public static function setCurrent($url = null) {
            $language = self::getLanguageByUrl($url);
            self::$current = ($language === null) ? self::getDefaultLanguage() : $language;
            Yii::$app->language = self::$current->local;
        }
    
        /**
         * Get default language
         *
         * @return null|Language
         */
        public static function getDefaultLanguage() {
            /**
             * @var null|Language $language
             */
            $language = self::find()->where(['default' => true])->one();
            return $language;
        }
    
        /**
         * Get language by Url param
         *
         * @param null|string $url Language url param
         *
         * @return null|Language
         */
        public static function getLanguageByUrl($url = null) {
            if($url === NULL) {
                return NULL;
            } else {
                /**
                 * @var null|Language $language
                 */
                $language = self::find()->where(['url' => $url])->one();
                if($language === NULL) {
                    return NULL;
                } else {
                    return $language;
                }
            }
        }
    }
