<?php
    
    namespace common\models;
    
    /**
     * Class Emails
     * @property int $id
     * @property string $username
     * @property string $email
     * @property string $phone
     * @property string $message
     * @property int $date_from
     * @property int $date_to
     * @property int $date_count
     */
    class Emails extends \yii\db\ActiveRecord
    {
        
        const SCENARIO_EMAIL = 'email';
        const SCENARIO_QUESTION = 'question';
        const SCENARIO_BOOKING = 'booking';
        const SCENARIO_KEY = 'key';
        
        public static function tableName()
        {
            return 'emails';
        }
        
        public function scenarios()
        {
            $scenario = parent::scenarios();
            $new_scenarios = [
                self::SCENARIO_EMAIL => [
                    'username',
                    'email',
                    'phone',
                ],
                self::SCENARIO_QUESTION => [
                    'username',
                    'email',
                    'phone',
                    'message'
                ],
                self::SCENARIO_BOOKING => [
                    'username',
                    'email',
                    'phone',
                    'date_from',
                    'date_to',
                ],
                self::SCENARIO_KEY => [
                    'username',
                    'email',
                    'phone',
                    'date_count',
                ],
            ];
            return array_merge($scenario, $new_scenarios);
        }
    
        public function rules()
        {
            return [
                [
                    [ 'username' ],
                    'string',
                    'min' => 2,
                    'max' => 255,
                ],
                
                [
                    'email',
                    'email',
                ],
                [
                    [
                        'email',
                        'phone',
                    ],
                    'string',
                    'max' => 255,
                ],
                
                [
                    'phone',
                    'required',
                ],
                [
                    'message',
                    'string',
                ],
                [
                    ['date_from', 'date_to'],
                    'safe',
                ],
                [
                    ['date_from', 'date_to'],
                    'filter',
                    'filter' => function($value) {
                        return strtotime($value);
                    }
                ],
                [
                    'date_count',
                    'integer',
                ],
            ];
        }
        
        public function attributeLabels()
        {
            return [
                'username' => \Yii::t('app', 'Имя'),
                'phone'    => \Yii::t('app', 'телефон'),
                'email'    => \Yii::t('app', 'e-mail'),
                'message'    => \Yii::t('app', 'сообщение'),
                'date_to'    => \Yii::t('app', 'дата проката до'),
                'date_from'    => \Yii::t('app', 'дата проката с'),
                'date_count'    => \Yii::t('app', 'количество дней'),
            ];
        }
        
    }