<?php
    
    namespace common\models;
    
    use Yii;
    use yii\base\Model;
    use yii\data\ActiveDataProvider;
    use common\models\Car;
    
    /**
     * CarSearch represents the model behind the search form about `common\models\Car`.
     */
    class CarSearch extends Car
    {
        
        const DEFAULT_MODEL = 'Nissan Leaf S';
        const DEFAULT_YEAR = 2013;
        const SCENARIO_PUBLIC = 'public';
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'car_id',
                        'year',
                        'build',
                    ],
                    'integer',
                ],
                [
                    [
                        'model',
                        'image',
                        'color',
                        'option',
                    ],
                    'safe',
                ],
                [
                    [
                        'mileage',
                        'price',
                    ],
                    'number',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function scenarios()
        {
            // bypass scenarios() implementation in the parent class
            $scenarios = parent::scenarios();
            $scenarios[self::SCENARIO_PUBLIC] = ['model', 'year'];
            return $scenarios;
        }
        
        /**
         * Creates data provider instance with search query applied
         *
         * @param array $params
         *
         * @return ActiveDataProvider
         */
        public function search($params)
        {
            $query = Car::find();
            
            // add conditions that should always apply here
            
            $dataProvider = new ActiveDataProvider([
                'query'      => $query,
                'pagination' => false,
            ]);
            
            $this->load($params);
            
            if(!$this->validate()) {
                // uncomment the following line if you do not want to return any records when validation fails
                // $query->where('0=1');
                return $dataProvider;
            }
            
            if($this->scenario == self::SCENARIO_PUBLIC) {
                if(empty( $this->model )) {
                    $this->model = self::DEFAULT_MODEL;
                };
                if(empty( $this->year )) {
                    $this->year = self::DEFAULT_YEAR;
                };
            }
            
            // grid filtering conditions
            $query->andFilterWhere([
                'car_id'  => $this->car_id,
                'year'    => $this->year,
                'mileage' => $this->mileage,
                'build'   => $this->build,
                'price'   => $this->price,
                'model'   => $this->model,
            ]);
            
            $query->andFilterWhere([
                    'like',
                    'image',
                    $this->image,
                ])
                  ->andFilterWhere([
                      'like',
                      'color',
                      $this->color,
                  ])
                  ->andFilterWhere([
                      'like',
                      'option',
                      $this->option,
                  ]);
            
            return $dataProvider;
        }
    }
