<?php
    
    namespace common\models;
    
    use Yii;
    use yii\web\UploadedFile;
    
    /**
     * This is the model class for table "car".
     * @property integer $car_id
     * @property string  $model
     * @property integer $year
     * @property string  $image
     * @property string  $color
     * @property double  $mileage
     * @property integer $build
     * @property string  $option
     * @property double  $price
     */
    class Car extends \yii\db\ActiveRecord
    {
        
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'car';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'model',
                        'year',
                    ],
                    'required',
                ],
                [
                    [ 'year' ],
                    'integer',
                ],
                [
                    [
                        'mileage',
                        'price',
                    ],
                    'number',
                ],
                [
                    [
                        'option',
                        'build',
                    ],
                    'string',
                ],
                [
                    [
                        'model',
                        'color',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'image' ],
                    'safe',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'car_id' => Yii::t('app', 'Ідентификатор'),
                'model' => Yii::t('app', 'Модель'),
                'year' => Yii::t('app', 'Год производства'),
                'image' => Yii::t('app', 'Изображение'),
                'color' => Yii::t('app', 'Цвет'),
                'mileage' => Yii::t('app', 'Пробег'),
                'build' => Yii::t('app', 'Дата выпуска'),
                'option' => Yii::t('app', 'Доп. опции'),
                'price' => Yii::t('app', 'Цена'),
            ];
        }
        
        public function upload()
        {
            /**
             * @var UploadedFile $image
             */
            $this->image = UploadedFile::getInstance($this, 'image');
            $image = $this->image;
            if(!empty( $image )) {
                $fullName = $image->baseName . time() . '.' . $image->extension;
                $path = Yii::getAlias('@storage') . '/' . $fullName;
                $image->saveAs($path);
                $image->name = '/storage/' . $fullName;
            } else {
                $this->image = $this->getOldAttribute('image');
            }
            return true;
        }
    }
