<?php
    
    namespace common\models;
    
    /**
     * Class Buys
     * @property int    $id
     * @property string $username
     * @property string $email
     * @property string $phone
     * @property string $model_name
     * @property int    $model_year
     * @property string $model_color
     */
    class Buys extends \yii\db\ActiveRecord
    {
        
        public static function tableName()
        {
            return 'buys';
        }
        
        public function rules()
        {
            return [
                [
                    [ 'username' ],
                    'string',
                    'min' => 2,
                    'max' => 255,
                ],
                
                [
                    'email',
                    'email',
                ],
                [
                    [
                        'email',
                        'phone',
                    ],
                    'string',
                    'max' => 255,
                ],
                
                [
                    'phone',
                    'required',
                ],
                [
                    [
                        'phone',
                        'model_name',
                        'model_year',
                        'model_color',
                    ],
                    'safe',
                ],
            
            ];
        }
        
        public function attributeLabels()
        {
            return [
                'username'    => 'Имя',
                'phone'       => 'телефон',
                'email'       => 'e-mail',
                'model_name'  => '',
                'model_year'  => '',
                'model_color' => '',
            ];
        }
        
    }