<?php
    
    use common\models\Car;
    use yii\helpers\Html;
    use yii\grid\GridView;
    
    /* @var $this yii\web\View */
    /* @var $searchModel common\models\CarSearch */
    /* @var $dataProvider yii\data\ActiveDataProvider */
    
    $this->title = 'Автомобили';
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="car-index">
    
    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    
    <p>
        <?= Html::a('Добавить автомобиль', [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
    </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'filterModel'  => $searchModel,
            'columns'      => [
                [ 'class' => 'yii\grid\ActionColumn' ],
                [
                    'attribute' => 'car_id',
                    'headerOptions' => [
                        'style' => 'word-break: break-all',
                    ],
                ],
                'model',
                'year',
                [
                    'attribute' => 'image',
                    'format'    => [
                        'image',
                        [
                            'style' => [ 'max-width' => '300px' ],
                        ],
                    ],
                ],
                'color',
                [
                    'attribute' => 'mileage',
                    'value'     => function ($model) {
                        /**
                         * @var Car $model
                         */
                        return $model->mileage . ' тыс. км.';
                    },
                ],
                'build',
                [
                    'attribute' => 'option',
                    'format' => 'ntext',
                    'contentOptions' => [
                        'style' => 'white-space: normal',
                    ],
                ],
                [
                    'attribute' => 'price',
                    'value'     => function ($model) {
                        /**
                         * @var Car $model
                         */
                        return '$' . number_format($model->price, 3);
                    },
                ],
                
            ],
        ]
    ); ?>
</div>
