<?php
    
    use kartik\file\FileInput;
    use yii\helpers\Html;
    use yii\jui\DatePicker;
    use yii\widgets\ActiveForm;
    
    /* @var $this yii\web\View */
    /* @var $model common\models\Car */
    /* @var $form yii\widgets\ActiveForm */
    
    $models = [
        'Nissan Leaf S'  => 'Nissan Leaf S',
        'Nissan Leaf SV' => 'Nissan Leaf SV',
        'Nissan Leaf SL' => 'Nissan Leaf SL',
    ];
    $years = [ ];
    for($year = 2013; $year <= date('Y'); $year++) {
        $years[ $year ] = $year;
    }
?>

<div class="car-form">
    
    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
    
    <?= $form->field($model, 'model')
             ->dropDownList($models) ?>
    
    <?= $form->field($model, 'year')
             ->dropDownList($years) ?>
    
    <?= $form->field($model, 'image')
             ->widget(FileInput::className(), [
                 'options' => [ 'accept' => 'image/*' ],
                 'pluginOptions' => [
                     'allowedFileExtensions' => ['jpg', 'png'],
                     'initialPreview' => ($model->image?(Html::img($model->image, ['width' => '240px'])):false),
                     'initialPreviewConfig' => [
                         'width' => '120px',
                     ],
                     'overwriteInitial' => true,
                     'showUpload' => false,
                     'previewFileType' => 'image',
                 ],
             ]) ?>
    
    <?= $form->field($model, 'color')
             ->textInput([ 'maxlength' => true ]) ?>
    
    <?= $form->field($model, 'mileage')
             ->textInput()
             ->label('Пробег (тыс. км.)') ?>
    
    <?= $form->field($model, 'build')
             ->widget(DatePicker::className(), [
                 'dateFormat'    => 'MM/yyyy',
                 'clientOptions' => [
                     'changeMonth' => true,
                     'changeYear'  => true,
                     'yearRange'   => '2013:' . date('Y'),
                 ],
                 'options'       => [
                     'class' => 'form-control',
                 ],
             ])
             ->label('Дата выпуска (выбор дня не влияет)') ?>
    
    <?= $form->field($model, 'option')
             ->textarea([ 'rows' => 6 ]) ?>
    
    <?= $form->field($model, 'price')
             ->textInput() ?>
    
    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]) ?>
    </div>
    
    <?php ActiveForm::end(); ?>

</div>
