<?php
    $params = array_merge(
        require(__DIR__ . '/../../common/config/params.php'),
        require(__DIR__ . '/../../common/config/params-local.php'),
        require(__DIR__ . '/params.php'),
        require(__DIR__ . '/params-local.php')
    );
    
    return [
        'id' => 'app-backend',
        'basePath' => dirname(__DIR__),
        'controllerNamespace' => 'backend\controllers',
        'bootstrap' => ['log'],
        'components' => [
            'user' => [
                'identityClass' => 'common\models\User',
                'enableAutoLogin' => true,
            ],
            'log' => [
                'traceLevel' => YII_DEBUG ? 3 : 0,
                'targets' => [
                    [
                        'class' => 'yii\log\FileTarget',
                        'levels' => ['error', 'warning'],
                    ],
                ],
            ],
            'errorHandler' => [
                'errorAction' => 'site/error',
            ],
            'request'=>[
                'cookieValidationKey' => 'j4iuot9u5894e7tu8reyh78g9y54sy7i',
                'csrfParam' => '_backendCSRF',

                'class' => 'common\components\Request',

                'web'=> '/backend/web',

                'adminUrl' => '/admin'

            ],
            'urlManager' => [
                'baseUrl' => '/admin',
                'enablePrettyUrl' => true,
                'showScriptName' => false,
            ]
        
        ],
        'params' => $params,
    ];
